chrome.alarms.onAlarm.addListener((alarm) => {
  if (alarm.name.startsWith("autoRun")) {
    console.log("⏳ נוצר טריגר להרצה – פתיחת כרטיסיות...");
    
    chrome.storage.local.get(["activeTasks"], (data) => {
      const tasks = data.activeTasks || [];
      const currentTask = tasks.find(t => t.alarmId === alarm.name);
      
      if (currentTask) {
        const runs = currentTask.runs || 1;
        const delayBetweenRuns = currentTask.delayBetweenRuns || 500;
        
        // פתיחת כרטיסייה עבור כל הרצה
        for (let i = 0; i < runs; i++) {
          setTimeout(() => {
            chrome.tabs.create({ 
              url: "https://creator.nightcafe.studio/studio" 
            });
            console.log(`🟢 פתיחת כרטיסייה ${i + 1}/${runs}`);
          }, i * delayBetweenRuns);
        }
      }
    });
  }
});